/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.GeometryRetained;
import javax.media.j3d.IndexedGeometryStripArrayRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.PickBounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickRay;
import javax.media.j3d.PickSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

class IndexedLineStripArrayRetained
extends IndexedGeometryStripArrayRetained {
    IndexedLineStripArrayRetained() {
        this.geoType = 14;
    }

    boolean intersect(PickShape pickShape, PickInfo pickInfo, int n2, Point3d point3d, GeometryRetained geometryRetained, int n3) {
        Point3d[] point3dArray = new Point3d[2];
        double[] dArray = new double[1];
        double d2 = Double.MAX_VALUE;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[2];
        point3dArray[0] = new Point3d();
        point3dArray[1] = new Point3d();
        switch (pickShape.getPickType()) {
            case 1: {
                PickRay pickRay = (PickRay)pickShape;
                while (n4 < this.stripIndexCounts.length) {
                    nArray[0] = this.indexCoord[n5];
                    this.getVertexData(this.indexCoord[n5++], point3dArray[0]);
                    int n6 = this.stripIndexCounts[n4++];
                    for (int i2 = 1; i2 < n6; ++i2) {
                        nArray[1] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[1]);
                        if (this.intersectLineAndRay(point3dArray[0], point3dArray[1], pickRay.origin, pickRay.direction, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 2: {
                PickSegment pickSegment = (PickSegment)pickShape;
                Vector3d vector3d = new Vector3d(pickSegment.end.x - pickSegment.start.x, pickSegment.end.y - pickSegment.start.y, pickSegment.end.z - pickSegment.start.z);
                while (n4 < this.stripIndexCounts.length) {
                    nArray[0] = this.indexCoord[n5];
                    this.getVertexData(this.indexCoord[n5++], point3dArray[0]);
                    int n7 = this.stripIndexCounts[n4++];
                    for (int i3 = 1; i3 < n7; ++i3) {
                        nArray[1] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[1]);
                        if (this.intersectLineAndRay(point3dArray[0], point3dArray[1], pickSegment.start, vector3d, dArray, point3d) && dArray[0] <= 1.0) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 6: {
                BoundingBox boundingBox = (BoundingBox)((PickBounds)pickShape).bounds;
                while (n4 < this.stripIndexCounts.length) {
                    nArray[0] = this.indexCoord[n5];
                    this.getVertexData(this.indexCoord[n5++], point3dArray[0]);
                    int n8 = this.stripIndexCounts[n4++];
                    for (int i4 = 1; i4 < n8; ++i4) {
                        nArray[1] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[1]);
                        if (this.intersectBoundingBox(point3dArray, boundingBox, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)((PickBounds)pickShape).bounds;
                while (n4 < this.stripIndexCounts.length) {
                    nArray[0] = this.indexCoord[n5];
                    this.getVertexData(this.indexCoord[n5++], point3dArray[0]);
                    int n9 = this.stripIndexCounts[n4++];
                    for (int i5 = 1; i5 < n9; ++i5) {
                        nArray[1] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[1]);
                        if (this.intersectBoundingSphere(point3dArray, boundingSphere, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)((PickBounds)pickShape).bounds;
                while (n4 < this.stripIndexCounts.length) {
                    nArray[0] = this.indexCoord[n5];
                    this.getVertexData(this.indexCoord[n5++], point3dArray[0]);
                    int n10 = this.stripIndexCounts[n4++];
                    for (int i6 = 1; i6 < n10; ++i6) {
                        nArray[1] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[1]);
                        if (this.intersectBoundingPolytope(point3dArray, boundingPolytope, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 4: {
                PickCylinder pickCylinder = (PickCylinder)pickShape;
                while (n4 < this.stripIndexCounts.length) {
                    nArray[0] = this.indexCoord[n5];
                    this.getVertexData(this.indexCoord[n5++], point3dArray[0]);
                    int n11 = this.stripIndexCounts[n4++];
                    for (int i7 = 1; i7 < n11; ++i7) {
                        nArray[1] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[1]);
                        if (this.intersectCylinder(point3dArray, pickCylinder, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 5: {
                PickCone pickCone = (PickCone)pickShape;
                while (n4 < this.stripIndexCounts.length) {
                    nArray[0] = this.indexCoord[n5];
                    this.getVertexData(this.indexCoord[n5++], point3dArray[0]);
                    int n12 = this.stripIndexCounts[n4++];
                    for (int i8 = 1; i8 < n12; ++i8) {
                        nArray[1] = this.indexCoord[n5];
                        this.getVertexData(this.indexCoord[n5++], point3dArray[1]);
                        if (this.intersectCone(point3dArray, pickCone, dArray, point3d)) {
                            if (n2 == 0) {
                                return true;
                            }
                            if (dArray[0] < d2) {
                                d2 = dArray[0];
                                d3 = point3d.x;
                                d4 = point3d.y;
                                d5 = point3d.z;
                                if ((n2 & 0x20) != 0) {
                                    this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                                }
                            }
                            if ((n2 & 0x40) != 0) {
                                this.storeInterestData(pickInfo, n2, geometryRetained, n3, nArray, point3d, dArray[0]);
                            }
                        }
                        point3dArray[0].set(point3dArray[1]);
                        nArray[0] = nArray[1];
                    }
                }
                break;
            }
            case 3: {
                throw new IllegalArgumentException(J3dI18N.getString("IndexedLineStripArrayRetained0"));
            }
            default: {
                throw new RuntimeException("PickShape not supported for intersection");
            }
        }
        if (d2 < Double.MAX_VALUE) {
            point3d.x = d3;
            point3d.y = d4;
            point3d.z = d5;
            return true;
        }
        return false;
    }

    boolean intersect(Point3d[] point3dArray) {
        int n2 = 0;
        int n3 = 0;
        Point3d[] point3dArray2 = new Point3d[2];
        double[] dArray = new double[1];
        point3dArray2[0] = new Point3d();
        point3dArray2[1] = new Point3d();
        switch (point3dArray.length) {
            case 3: 
            case 4: {
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray2[0]);
                    int n4 = this.stripIndexCounts[n2++];
                    for (int i2 = 1; i2 < n4; ++i2) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray2[1]);
                        if (this.intersectSegment(point3dArray, point3dArray2[0], point3dArray2[1], dArray, null)) {
                            return true;
                        }
                        point3dArray2[0].set(point3dArray2[1]);
                    }
                }
                break;
            }
            case 2: {
                Vector3d vector3d = new Vector3d();
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray2[0]);
                    int n5 = this.stripIndexCounts[n2++];
                    for (int i3 = 1; i3 < n5; ++i3) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray2[1]);
                        vector3d.x = point3dArray2[1].x - point3dArray2[0].x;
                        vector3d.y = point3dArray2[1].y - point3dArray2[0].y;
                        vector3d.z = point3dArray2[1].z - point3dArray2[0].z;
                        if (this.intersectLineAndRay(point3dArray[0], point3dArray[1], point3dArray2[0], vector3d, dArray, null) && dArray[0] <= 1.0) {
                            return true;
                        }
                        point3dArray2[0].set(point3dArray2[1]);
                    }
                }
                break;
            }
            case 1: {
                Vector3d vector3d = new Vector3d();
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray2[0]);
                    int n6 = this.stripIndexCounts[n2++];
                    for (int i4 = 1; i4 < n6; ++i4) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray2[1]);
                        vector3d.x = point3dArray2[1].x - point3dArray2[0].x;
                        vector3d.y = point3dArray2[1].y - point3dArray2[0].y;
                        vector3d.z = point3dArray2[1].z - point3dArray2[0].z;
                        if (this.intersectPntAndRay(point3dArray[0], point3dArray2[0], vector3d, dArray) && dArray[0] <= 1.0) {
                            return true;
                        }
                        point3dArray2[0].set(point3dArray2[1]);
                    }
                }
                break;
            }
        }
        return false;
    }

    boolean intersect(Transform3D transform3D, GeometryRetained geometryRetained) {
        int n2 = 0;
        int n3 = 0;
        Point3d[] point3dArray = new Point3d[]{new Point3d(), new Point3d()};
        while (n2 < this.stripIndexCounts.length) {
            this.getVertexData(this.indexCoord[n3++], point3dArray[0]);
            transform3D.transform(point3dArray[0]);
            int n4 = this.stripIndexCounts[n2++];
            for (int i2 = 1; i2 < n4; ++i2) {
                this.getVertexData(this.indexCoord[n3++], point3dArray[1]);
                transform3D.transform(point3dArray[1]);
                if (geometryRetained.intersect(point3dArray)) {
                    return true;
                }
                point3dArray[0].set(point3dArray[1]);
            }
        }
        return false;
    }

    boolean intersect(Bounds bounds) {
        int n2 = 0;
        int n3 = 0;
        Point3d[] point3dArray = new Point3d[]{new Point3d(), new Point3d()};
        switch (bounds.getPickType()) {
            case 6: {
                BoundingBox boundingBox = (BoundingBox)bounds;
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray[0]);
                    int n4 = this.stripIndexCounts[n2++];
                    for (int i2 = 1; i2 < n4; ++i2) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray[1]);
                        if (this.intersectBoundingBox(point3dArray, boundingBox, null, null)) {
                            return true;
                        }
                        point3dArray[0].set(point3dArray[1]);
                    }
                }
                break;
            }
            case 7: {
                BoundingSphere boundingSphere = (BoundingSphere)bounds;
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray[0]);
                    int n5 = this.stripIndexCounts[n2++];
                    for (int i3 = 1; i3 < n5; ++i3) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray[1]);
                        if (this.intersectBoundingSphere(point3dArray, boundingSphere, null, null)) {
                            return true;
                        }
                        point3dArray[0].set(point3dArray[1]);
                    }
                }
                break;
            }
            case 8: {
                BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
                while (n2 < this.stripIndexCounts.length) {
                    this.getVertexData(this.indexCoord[n3++], point3dArray[0]);
                    int n6 = this.stripIndexCounts[n2++];
                    for (int i4 = 1; i4 < n6; ++i4) {
                        this.getVertexData(this.indexCoord[n3++], point3dArray[1]);
                        if (this.intersectBoundingPolytope(point3dArray, boundingPolytope, null, null)) {
                            return true;
                        }
                        point3dArray[0].set(point3dArray[1]);
                    }
                }
                break;
            }
            default: {
                throw new RuntimeException("Bounds not supported for intersection " + bounds);
            }
        }
        return false;
    }

    int getClassType() {
        return 2;
    }
}

